//These variables will get set automatically
texture rubyTexture;

sampler s0 = sampler_state { texture = <rubyTexture>; };


float4 DiffColourPass( in float2 Tex : TEXCOORD0 ) : COLOR0
{
        float4 Color = tex2D( s0, Tex );
	Color.a = 1.0f;
        Color.rgb = (Color.r+Color.g+Color.b)/3.0f;
        if (Color.r<0.2 || Color.r>0.8) Color.r = 0.0f; else Color.r = 1.0f;
        if (Color.g<0.2 || Color.g>0.8) Color.g = 0.0f; else Color.g = 1.0f;
        if (Color.b<0.2 || Color.b>0.8) Color.b = 0.0f; else Color.b = 1.0f;
	return Color;
}




Technique T0
{
    pass p0 { PixelShader = compile ps_2_0 DiffColourPass(); }
}

